package it.eng.eremita.jpa.util;

import java.util.HashMap;
import java.util.Map;

import it.eng.eremita.graphql.types.Identifiable;
import it.eng.eremita.jpa.entity.Documento;
import it.eng.eremita.jpa.entity.MonitoraggioHabitat;
import it.eng.eremita.jpa.entity.MonitoraggioSpecie;
import it.eng.eremita.jpa.entity.Utente;

public class ObjectAuthorizerFactory {
	
	static Map<Class,ObjectAuthorizer> authorizers;
	
	static {
		
		authorizers = new HashMap<>();
		
		authorizers.put(MonitoraggioSpecie.class, new ObjectAuthorizer<MonitoraggioSpecie>());
		authorizers.put(MonitoraggioHabitat.class, new ObjectAuthorizer<MonitoraggioHabitat>());
		authorizers.put(Documento.class, new ObjectAuthorizer<Documento>());
		
	}
	
	private static ObjectAuthorizer getAuthorizer(Object x) {
		if (x==null) return null;
		return authorizers.get(x.getClass());
	}
	
	public static boolean isAuthorized(Utente u, Object x, String permissionType) {
		
		ObjectAuthorizer oa = getAuthorizer(x);
		if (oa==null) return true;
		
		return oa.isAuthorized(u, x, permissionType);
		
	}
	
	public static boolean isAuthorized(Utente u, Object x) {
		if (x instanceof Identifiable) {
			Object id = ((Identifiable)x).getId();
			if (id==null) return isAuthorized(u, x, "INSERT");
			else return isAuthorized(u, x, "WRITE");
		}
		return isAuthorized(u, x, "WRITE");
	}

	
	public static boolean isAuthorizedWrite(Utente u, Object x) {
		return isAuthorized(u, x, "WRITE");
	}
	
	public static boolean isAuthorizedRead(Utente u, Object x) {
		return isAuthorized(u, x, "WRITE");
	}
	
	public static String getQueryCondition(Utente u, Object x, String aliasTabella) {
		//if (1==1) return null;
		ObjectAuthorizer oa = getAuthorizer(x);
		if (oa==null) return null;
		return oa.getQueryCondition(u, x, aliasTabella);
	}
}
